Phantom keyboard firmware
======================
DIY keyboard developed by Geekhack and Deskthority communities.
The PCB was engineered by bpiphany from the original idea of HaveANiceDay.

## Wiki on Deskthority.net
- [Info](http://deskthority.net/wiki/Phantom)
- [Assembly Instructions](http://deskthority.net/wiki/Phantom)


Build
-----
Move to this directory then just run `make` like:

    $ make -f Makefile.[pjrc|lufa] [ansi|ansi_150|iso|iso_150|7bit]

Use `Makefile.pjrc` if you want to use PJRC stack or use `Makefile.lufa` for LUFA stack.


LEDs
----
It is possible to configure the LEDs in 2 different ways.

### 1. LED Brightness
The brightness of the LEDs can be controlled by software.

To select brightness edit [config.h](config.h) and set `LED_BRIGHTNESS` to a value
between 0 and 255:

    #define LED_BRIGHTNESS  250


### 2. Sleep LED
It is possible to have the LEDs fade in and out when the computer is suspended.

To enable this feature, uncomment the `SLEEP_LED_ENABLE` line in the makefile you are using:

    SLEEP_LED_ENABLE = yes  # Breathing sleep LED during USB suspend

*Note that this will set the LEDs to full brightness as this feature can't be combined with the brightness control.*


Keymap
------
The PCB supports multiple physical layouts.
Each layout have their own keymap file.

*Note that only the ANSI keymap is tested on actual hardware.*

To customize a keymap:

1. Edit the file that corresponds to your layout.
2. Specify your layout when building.

See [keymap.c](keymap.c) to define your own custom layout.


### 1. ANSI
This is the default keymap.

See [keymap_ansi.h](keymap_ansi.h) for detail.

#### 1.0. ANSI Default Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Esc|   |F1 |F2 |F3 |F4 | |F5 |F6 |F7 |F8 | |F9 |F10|F11|F12| |PrS|ScL|Pau|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|Backsp | |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|    \| |Del|End|PgD|
     |-----------------------------------------------------------| '-----------'
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|Return  |
     |-----------------------------------------------------------|     ,---.
     |Shift   |  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift     |     |Up |
     |-----------------------------------------------------------| ,-----------.
     |Ctl|Gui|Alt|             Space             |Alt|Gui|App|Ctl| |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 1.1. ANSI Media Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |   |   |   |   |   |   | |   |   |   |   | |   |   |   |   | |   |   |Slp|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |       | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|Media| |   |   |   |
     |-----------------------------------------------------------| '-----------'
     |      |   |   |   |   |   |   |   |   |   |   |   |        |
     |-----------------------------------------------------------|     ,---.
     |        |   |   |Clc|   |   |   |   |   |   |   |Caps      |     |   |
     |-----------------------------------------------------------| ,-----------.
     |   |   |   |                               |   |   |   |   | |   |   |   |
     `-----------------------------------------------------------' `-----------'


### 2. ANSI 150
Layout with 1.5 unit modifiers.

See [keymap_ansi_150.h](keymap_ansi_150.h) for detail.

#### 2.0. ANSI 150 Default Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Esc|   |F1 |F2 |F3 |F4 | |F5 |F6 |F7 |F8 | |F9 |F10|F11|F12| |PrS|ScL|Pau|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|Backsp | |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|    \| |Del|End|PgD|
     |-----------------------------------------------------------| '-----------'
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|Return  |
     |-----------------------------------------------------------|     ,---.
     |Shift   |  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift     |     |Up |
     |-----------------------------------------------------------| ,-----------.
     |Ctl |Gui|Alt |             Space             |Alt |Gui|Ctl | |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 2.1. ANSI 150 Media Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |   |   |   |   |   |   | |   |   |   |   | |   |   |   |   | |   |   |Slp|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |       | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|Media| |   |   |   |
     |-----------------------------------------------------------| '-----------'
     |      |   |   |   |   |   |   |   |   |   |   |   |        |
     |-----------------------------------------------------------|     ,---.
     |        |   |   |Clc|   |   |   |   |   |   |   |Caps      |     |   |
     |-----------------------------------------------------------| ,-----------.
     |    |   |    |                               |    |   |    | |   |   |   |
     `-----------------------------------------------------------' `-----------'


### 3. ISO
ISO layout.

See [keymap_iso.h](keymap_iso.h) for detail.

#### 3.0. ISO Default Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Esc|   |F1 |F2 |F3 |F4 | |F5 |F6 |F7 |F8 | |F9 |F10|F11|F12| |PrS|ScL|Pau|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|Backsp | |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|     | |Del|End|PgD|
     |------------------------------------------------------` Ret| '-----------'
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|  #|    |
     |-----------------------------------------------------------|     ,---.
     |Shif|  \|  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift     |     |Up |
     |-----------------------------------------------------------| ,-----------.
     |Ctl|Gui|Alt|             Space             |Alt|Gui|App|Ctl| |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 3.1. ISO Media Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |   |   |   |   |   |   | |   |   |   |   | |   |   |   |   | |   |   |Slp|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |       | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|     | |   |   |   |
     |------------------------------------------------------` Med| '-----------'
     |      |   |   |   |   |   |   |   |   |   |   |   |   |    |
     |-----------------------------------------------------------|     ,---.
     |    |   |   |   |Clc|   |   |   |   |   |   |   |Caps      |     |   |
     |-----------------------------------------------------------| ,-----------.
     |   |   |   |                               |   |   |   |   | |   |   |   |
     `-----------------------------------------------------------' `-----------'


### 4. ISO 150
ISO layout with 1.5 unit modifiers.

See [keymap_iso_150.h](keymap_iso_150.h) for detail.

#### 4.0. ISO 150 Default Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |Esc|   |F1 |F2 |F3 |F4 | |F5 |F6 |F7 |F8 | |F9 |F10|F11|F12| |PrS|ScL|Pau|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|Backsp | |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|     | |Del|End|PgD|
     |------------------------------------------------------` Ret| '-----------'
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|  #|    |
     |-----------------------------------------------------------|     ,---.
     |Shif|  \|  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift     |     |Up |
     |-----------------------------------------------------------| ,-----------.
     |Ctl |Gui|Alt |             Space             |Alt |Gui|Ctl | |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 4.1. ISO 150 Media Layer
     ,---.   ,---------------. ,---------------. ,---------------. ,-----------.
     |   |   |   |   |   |   | |   |   |   |   | |   |   |   |   | |   |   |Slp|
     `---'   `---------------' `---------------' `---------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |       | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|     | |   |   |   |
     |------------------------------------------------------` Med| '-----------'
     |      |   |   |   |   |   |   |   |   |   |   |   |   |    |
     |-----------------------------------------------------------|     ,---.
     |    |   |   |   |Clc|   |   |   |   |   |   |   |Caps      |     |   |
     |-----------------------------------------------------------| ,-----------.
     |    |   |    |                               |    |   |    | |   |   |   |
     `-----------------------------------------------------------' `-----------'


### 5. 7bit
Layout using all the available keys on the PCB.

This keymap is only provided as an example of what can be done using this layout.
No real thought has been put into this keymap.

See [keymap_7bit.h](keymap_7bit.h) for detail.

#### 5.0. 7bit Default Layer
     ,-----------------------------------------------------------. ,-----------.
     |Esc|F1 |F2 |F3 |F4 |F5 |F6 |F7 |F8 |F9 |F10|F11|F12|V- |V+ | |PrS|ScL|Pau|
     `-----------------------------------------------------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |~  |  1|  2|  3|  4|  5|  6|  7|  8|  9|  0|  -|  =|  (|  )| |Ins|Hom|PgU|
     |-----------------------------------------------------------| |-----------|
     |Tab  |  Q|  W|  E|  R|  T|  Y|  U|  I|  O|  P|  [|  ]|Backs| |Del|End|PgD|
     |-----------------------------------------------------------| |-----------|
     |Fn0   |  A|  S|  D|  F|  G|  H|  J|  K|  L|  ;|  '|  \| Ret| |Stp|Ply|Med|
     |-----------------------------------------------------------| |-----------|
     |Cap|Shif|  Z|  X|  C|  V|  B|  N|  M|  ,|  .|  /|Shift |Cap| |Prv|Up |Nxt|
     |-----------------------------------------------------------| |-----------|
     |Ctrl |Gui|Alt  |Spc  |Bspc |Del|Ret  |Alt  |Gui  |App|Ctrl | |Lef|Dow|Rig|
     `-----------------------------------------------------------' `-----------'

#### 5.1. 7bit Media Layer
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   | |   |   |Slp|
     `-----------------------------------------------------------' `-----------'
     ,-----------------------------------------------------------. ,-----------.
     |   |   |   |   |   |   |   |   |   |   |Mut|V- |V+ |   |   | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |   |   |   |   |   |   |   |Stp|Ply|Prv|Nxt|Media| |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |      |   |   |   |   |   |   |   |   |   |   |   |   |    | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |   |    |   |   |   |   |   |   |   |   |   |   |      |   | |   |   |   |
     |-----------------------------------------------------------| |-----------|
     |     |   |     |     |     |   |     |     |     |   |     | |   |   |   |
     `-----------------------------------------------------------' `-----------'
